/*
 * Decompiled with CFR 0.152.
 */
package com.titan.stats;

import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;

public class EntityListener {
    public static ConcurrentHashMap<String, Stats> map = new ConcurrentHashMap();

    private static Stats getStats(Object entity) {
        String name = entity.getClass().getName();
        Stats stats = map.get(name);
        if (stats == null) {
            stats = new Stats();
            map.put(name, stats);
            stats.entity = name;
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostUpdate
    public void update(Object entity) {
        Stats stats;
        System.out.println("@PostUpdate: " + entity.getClass().getName());
        Stats stats2 = stats = EntityListener.getStats(entity);
        synchronized (stats2) {
            ++stats.updates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostPersist
    public void persist(Object entity) {
        Stats stats;
        System.out.println("@PostPersist: " + entity.getClass().getName());
        Stats stats2 = stats = EntityListener.getStats(entity);
        synchronized (stats2) {
            ++stats.inserts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostLoad
    public void load(Object entity) {
        Stats stats;
        System.out.println("@PostLoad: " + entity.getClass().getName());
        Stats stats2 = stats = EntityListener.getStats(entity);
        synchronized (stats2) {
            ++stats.loads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostRemove
    public void remove(Object entity) {
        Stats stats;
        System.out.println("@PostRemove: " + entity.getClass().getName());
        Stats stats2 = stats = EntityListener.getStats(entity);
        synchronized (stats2) {
            ++stats.removes;
        }
    }

    public static class Stats {
        public String entity;
        public int updates;
        public int loads;
        public int inserts;
        public int removes;
    }
}

