/*
 * Decompiled with CFR 0.152.
 */
package com.titan.clients;

import com.titan.clients.InitializeDB;
import com.titan.domain.Customer;
import com.titan.domain.Reservation;
import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class Bulk {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap map = new HashMap();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"titan", map);
        EntityManager entityManager = factory.createEntityManager();
        entityManager.getTransaction().begin();
        try {
            System.out.println("Initialize DB");
            InitializeDB.initialize(entityManager);
            System.out.println();
            System.out.println();
            entityManager.flush();
            entityManager.clear();
            Bulk.bulkUpdate(entityManager);
            entityManager.clear();
            Bulk.bulkDelete(entityManager);
            entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            entityManager.close();
            factory.close();
        }
    }

    public static void bulkUpdate(EntityManager manager) {
        System.out.println("Bulk Update");
        System.out.println("--------------------------------");
        System.out.println("UPDATE Reservation res set res.amountPaid = (res.amountPaid + 10)");
        System.out.println("WHERE EXISTS (");
        System.out.println("      SELECT c FROM res.customers c WHERE c.firstName = 'Bill' AND c.lastName='Burke'");
        System.out.println(")");
        System.out.println("Show all amount paid for all of Bill's reservations before update:");
        Customer bill = (Customer)manager.createQuery("SELECT c FROM Customer c where c.firstName = 'Bill' and c.lastName='Burke'").getSingleResult();
        Collection<Reservation> reservations = bill.getReservations();
        for (Reservation res : reservations) {
            System.out.println("amountPaid: " + res.getAmountPaid());
        }
        Query query = manager.createQuery("UPDATE Reservation res SET res.amountPaid = (res.amountPaid + 10) WHERE EXISTS (      SELECT c FROM res.customers c WHERE c.firstName = 'Bill' AND c.lastName='Burke')");
        query.executeUpdate();
        manager.flush();
        manager.clear();
        System.out.println("Show all amount paid for all of Bill's reservations after update:");
        bill = (Customer)manager.createQuery("SELECT c FROM Customer c where c.firstName = 'Bill' and c.lastName='Burke'").getSingleResult();
        reservations = bill.getReservations();
        for (Reservation res : reservations) {
            System.out.println("amountPaid: " + res.getAmountPaid());
        }
    }

    public static void bulkDelete(EntityManager manager) {
        System.out.println("Bulk Delete");
        System.out.println("--------------------------------");
        System.out.println("DELETE FROM Reservation res");
        System.out.println("WHERE EXISTS (");
        System.out.println("      SELECT c FROM res.customers c WHERE c.firstName = 'Bill' AND c.lastName='Burke'");
        System.out.println(")");
        System.out.println("Show all amount paid for all of Bill's reservations before update:");
        Customer bill = (Customer)manager.createQuery("SELECT c FROM Customer c where c.firstName = 'Bill' and c.lastName='Burke'").getSingleResult();
        Collection<Reservation> reservations = bill.getReservations();
        for (Reservation res : reservations) {
            System.out.println("amountPaid: " + res.getAmountPaid());
        }
        manager.clear();
        Query query = manager.createQuery("DELETE FROM Reservation res WHERE EXISTS (      SELECT c FROM res.customers c WHERE c.firstName = 'Bill' AND c.lastName='Burke')");
        query.executeUpdate();
        manager.flush();
        manager.clear();
        System.out.println("Show all amount paid for all of Bill's reservations after update:");
        bill = (Customer)manager.createQuery("SELECT c FROM Customer c where c.firstName = 'Bill' and c.lastName='Burke'").getSingleResult();
        reservations = bill.getReservations();
        for (Reservation res : reservations) {
            System.out.println("amountPaid: " + res.getAmountPaid());
        }
    }
}

