/*
 * Decompiled with CFR 0.152.
 */
package com.titan.clients;

import com.titan.clients.InitializeDB;
import com.titan.domain.Cruise;
import com.titan.domain.Reservation;
import com.titan.domain.Ship;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class InnerJoin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap map = new HashMap();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"titan", map);
        EntityManager entityManager = factory.createEntityManager();
        entityManager.getTransaction().begin();
        try {
            System.out.println("Initialize DB");
            InitializeDB.initialize(entityManager);
            System.out.println();
            System.out.println();
            InnerJoin.innerJoin(entityManager);
        }
        finally {
            entityManager.getTransaction().commit();
            entityManager.close();
            factory.close();
        }
    }

    public static void innerJoin(EntityManager entityManager) {
        System.out.println("THE IN OPERATOR and INNER JOIN");
        System.out.println("--------------------------------");
        System.out.println("SELECT r");
        System.out.println("FROM Customer AS c, IN( c.reservations ) r");
        Query query = entityManager.createQuery("SELECT r FROM Customer AS c , IN( c.reservations ) r");
        List reservations = query.getResultList();
        for (Reservation reservation : reservations) {
            System.out.println("   Reservation for " + reservation.getCruise().getName());
        }
        System.out.println("");
        System.out.println("SELECT r.cruise");
        System.out.println("FROM Customer AS c, IN( c.reservations ) r");
        query = entityManager.createQuery("SELECT r.cruise FROM Customer AS c, IN( c.reservations ) r");
        List cruises = query.getResultList();
        for (Cruise cruise : cruises) {
            System.out.println("   Cruise " + cruise.getName());
        }
        System.out.println("");
        System.out.println("SELECT cbn.ship");
        System.out.println("FROM Customer AS c, IN( c.reservations ) r,");
        System.out.println("IN( r.cabins ) AS cbn");
        query = entityManager.createQuery("SELECT cbn.ship FROM Customer AS c, IN( c.reservations ) r,IN( r.cabins ) cbn");
        List ships = query.getResultList();
        for (Ship ship : ships) {
            System.out.println("   Ship " + ship.getName());
        }
        System.out.println("");
        System.out.println("SELECT cbn.ship");
        System.out.println("FROM Customer c INNER JOIN c.reservations r ");
        System.out.println("INNER JOIN r.cabins cbn");
        query = entityManager.createQuery("SELECT cbn.ship FROM Customer c INNER JOIN c.reservations r INNER JOIN r.cabins cbn");
        ships = query.getResultList();
        for (Ship ship : ships) {
            System.out.println("   Ship " + ship.getName());
        }
        System.out.println("");
    }
}

