/*
 * Decompiled with CFR 0.152.
 */
package com.titan.clients;

import com.titan.clients.InitializeDB;
import com.titan.domain.Cruise;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class Subqueries {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap map = new HashMap();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"titan", map);
        EntityManager entityManager = factory.createEntityManager();
        entityManager.getTransaction().begin();
        try {
            System.out.println("Initialize DB");
            InitializeDB.initialize(entityManager);
            System.out.println();
            System.out.println();
            Subqueries.subquery(entityManager);
            System.out.println();
            System.out.println();
            Subqueries.subqueryALL(entityManager);
            System.out.println();
            System.out.println();
            Subqueries.subqueryANY(entityManager);
            System.out.println();
            System.out.println();
            Subqueries.subqueryEXISTS(entityManager);
            entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            entityManager.close();
            factory.close();
        }
    }

    public static void subquery(EntityManager manager) {
        System.out.println("Subquery");
        System.out.println("--------------------------------");
        System.out.println("SELECT COUNT(res) FROM Reservation res");
        System.out.println("WHERE res.amountPaid >");
        System.out.println("(SELECT AVG(r.amountPaid) FROM Reservation r)");
        Query query = manager.createQuery("SELECT COUNT(res) FROM Reservation res WHERE res.amountPaid > (SELECT AVG(r.amountPaid) FROM Reservation r)");
        long count = (Long)query.getSingleResult();
        System.out.println("Number of reservations paid above the average: " + count);
    }

    public static void subqueryALL(EntityManager manager) {
        System.out.println("Subquery with ALL");
        System.out.println("--------------------------------");
        System.out.println("FROM Cruise cr");
        System.out.println("WHERE 0 < ALL");
        System.out.println("(SELECT res.amountPaid from cr.reservations res)");
        Query query = manager.createQuery("SELECT cr FROM Cruise cr WHERE 0 < ALL(SELECT res.amountPaid from cr.reservations res)");
        List cruises = query.getResultList();
        System.out.println("Cruises where all reservations have down payments:");
        for (Cruise cr : cruises) {
            System.out.println("\t" + cr.getName());
        }
    }

    public static void subqueryANY(EntityManager manager) {
        System.out.println("Subquery with ANY");
        System.out.println("--------------------------------");
        System.out.println("FROM Cruise cr");
        System.out.println("WHERE 0 = ANY");
        System.out.println("(SELECT res.amountPaid from cr.reservations res)");
        Query query = manager.createQuery("SELECT cr FROM Cruise cr WHERE 0 = ANY(SELECT res.amountPaid from cr.reservations res)");
        List cruises = query.getResultList();
        System.out.println("Cruises where any reservation doesn't have down payments:");
        for (Cruise cr : cruises) {
            System.out.println("\t" + cr.getName());
        }
    }

    public static void subqueryEXISTS(EntityManager manager) {
        System.out.println("Subquery with EXISTS");
        System.out.println("--------------------------------");
        System.out.println("FROM Cruise cr");
        System.out.println("WHERE NOT EXISTS");
        System.out.println("(SELECT res.amountPaid from cr.reservations res WHERE res.amountPaid = 0)");
        Query query = manager.createQuery("SELECT cr FROM Cruise cr WHERE NOT EXISTS(SELECT res.amountPaid from cr.reservations res WHERE res.amountPaid = 0)");
        List cruises = query.getResultList();
        System.out.println("Cruises that have reservations that don't have a down payment:");
        for (Cruise cr : cruises) {
            System.out.println("\t" + cr.getName());
        }
    }
}

