/*
 * Decompiled with CFR 0.152.
 */
package com.titan.domain;

import com.titan.domain.Cabin;
import com.titan.domain.Cruise;
import com.titan.domain.Customer;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@TableGenerator(name="ReservationGenerator")
public class Reservation
implements Serializable {
    private int id;
    private Date date;
    private double amountPaid;
    private Cruise cruise;
    private Set<Cabin> cabins = new HashSet<Cabin>();
    private Set<Customer> customers = new HashSet<Customer>();

    public Reservation() {
    }

    public Reservation(Customer customer, Cruise cruise, Cabin cabin, double price, Date dateBooked) {
        this.setAmountPaid(price);
        this.setDate(dateBooked);
        this.setCruise(cruise);
        HashSet<Cabin> cabins = new HashSet<Cabin>();
        cabins.add(cabin);
        this.setCabins(cabins);
        HashSet<Customer> customers = new HashSet<Customer>();
        customers.add(customer);
        this.setCustomers(customers);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="ReservationGenerator")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="RES_DATE")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public double getAmountPaid() {
        return this.amountPaid;
    }

    public void setAmountPaid(double amount) {
        this.amountPaid = amount;
    }

    @ManyToOne
    @JoinColumn(name="CRUISE_ID")
    public Cruise getCruise() {
        return this.cruise;
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    @ManyToMany
    @JoinTable(name="RESERVATION_CABIN", joinColumns={@JoinColumn(name="RESERVATION_ID")}, inverseJoinColumns={@JoinColumn(name="CABIN_ID")})
    public Set<Cabin> getCabins() {
        return this.cabins;
    }

    public void setCabins(Set<Cabin> cabins) {
        this.cabins = cabins;
    }

    @ManyToMany
    @JoinTable(name="RESERVATION_CUSTOMER", joinColumns={@JoinColumn(name="RESERVATION_ID")}, inverseJoinColumns={@JoinColumn(name="CUSTOMER_ID")})
    public Set<Customer> getCustomers() {
        return this.customers;
    }

    public void setCustomers(Set<Customer> customers) {
        this.customers = customers;
    }
}

