/*
 * Decompiled with CFR 0.152.
 */
package com.titan.travelagent;

import com.titan.domain.Address;
import com.titan.domain.Cabin;
import com.titan.domain.Cruise;
import com.titan.domain.CruiseCabin;
import com.titan.domain.Customer;
import com.titan.domain.Reservation;
import com.titan.processpayment.CreditCardDO;
import com.titan.processpayment.ProcessPaymentLocal;
import com.titan.travelagent.IncompleteConversationalState;
import com.titan.travelagent.TicketDO;
import com.titan.travelagent.TravelAgentRemote;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;

@Stateful
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class TravelAgentBean
implements TravelAgentRemote {
    @PersistenceContext(unitName="titan", type=PersistenceContextType.EXTENDED)
    private EntityManager entityManager;
    @EJB
    private ProcessPaymentLocal processPayment;
    private Customer customer;
    private Cruise cruise;
    private Cabin cabin;
    private List<Object> toPersist = new ArrayList<Object>();
    private List<Object> toUpdate = new ArrayList<Object>();

    @Override
    public Customer findOrCreateCustomer(String first, String last) {
        try {
            Query q = this.entityManager.createQuery("SELECT c from Customer c where c.firstName = :first and c.lastName = :last");
            q.setParameter("first", (Object)first);
            q.setParameter("last", (Object)last);
            this.customer = (Customer)q.getSingleResult();
        }
        catch (NoResultException notFound) {
            this.customer = new Customer();
            this.customer.setFirstName(first);
            this.customer.setLastName(last);
            this.toPersist.add(this.customer);
        }
        return this.customer;
    }

    @Override
    public void updateAddress(Address addr) {
        this.customer.setAddress(addr);
        if (!this.toPersist.contains(this.customer)) {
            this.toUpdate.add(this.customer);
        }
    }

    @Override
    public void setCabinID(int cabinID) {
        this.cabin = (Cabin)this.entityManager.find(Cabin.class, (Object)cabinID);
        if (this.cabin == null) {
            throw new NoResultException("Cabin not found");
        }
    }

    @Override
    public void setCruiseID(int cruiseID) {
        this.cruise = (Cruise)this.entityManager.find(Cruise.class, (Object)cruiseID);
        if (this.cruise == null) {
            throw new NoResultException("Cruise not found");
        }
    }

    @Override
    public TicketDO bookPassage(CreditCardDO card, double price) throws IncompleteConversationalState {
        if (this.customer == null || this.cruise == null || this.cabin == null) {
            throw new IncompleteConversationalState();
        }
        Reservation reservation = new Reservation(this.customer, this.cruise, this.cabin, price, new Date());
        this.toPersist.add(reservation);
        Query getCruiseCabin = this.entityManager.createQuery("SELECT cc FROM CruiseCabin cc WHERE cc.cabin = :cabin AND cc.cruise = :cruise");
        getCruiseCabin.setParameter("cabin", (Object)this.cabin);
        getCruiseCabin.setParameter("cruise", (Object)this.cruise);
        CruiseCabin cc = (CruiseCabin)getCruiseCabin.getSingleResult();
        if (cc.getIsReserved()) {
            throw new EJBException("Cabin is already reserved");
        }
        cc.setIsReserved(true);
        try {
            this.processPayment.byCredit(this.customer, card, price);
            TicketDO ticket = new TicketDO(this.customer, this.cruise, this.cabin, price);
            return ticket;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    @Override
    @Remove
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void checkout() {
        for (Object persist : this.toPersist) {
            this.entityManager.persist(persist);
        }
        for (Object update : this.toUpdate) {
            this.entityManager.merge(update);
        }
        this.entityManager.flush();
    }
}

