package com.titan.clients;

import java.util.List;

import javax.naming.Context;

import com.titan.access.DataAccess;
import com.titan.domain.Reservation;

public class Client 
{
    public static void main(String [] args) 
    {
        try 
	{
            Context jndiContext = getInitialContext();
            Object ref = jndiContext.lookup(DataAccess.class.getName());
            DataAccess dao = (DataAccess)ref;

            System.out.println("Fetch reservations with loaded relationships");
            System.out.println();
            List list = dao.fetchReservationsWithRelationships();
            for (Object obj : list)
            {
               Reservation res = (Reservation)obj;
               System.out.println("Reservation for: " + res.getCruise().getName());
               System.out.println("\tNum cabins: " + res.getCabins().size());
               System.out.println("\tNum customers: " + res.getCustomers().size());
            }
            System.out.println("----------");
            System.out.println("Try to access uninitialized relationships");
            System.out.println("----------");
            list = dao.fetchReservations();
            System.out.println("List size: " + list.size());
            for (Object obj : list)
            {
               Reservation res = (Reservation)obj;
               System.out.println("Reservation for: " + res.getCruise().getName());
               try
               {
                  System.out.println("\tNum cabins: " + res.getCabins().size());
                  System.out.println("\tNum customers: " + res.getCustomers().size());
               }
               catch (Exception ex)
               {
                  System.out.println(ex.getClass().getName() + " : " + ex.getMessage());
               }
            }
        } 
        catch (javax.naming.NamingException ne)
        {
	    ne.printStackTrace();
	}
    }

    public static Context getInitialContext() 
        throws javax.naming.NamingException 
    {
        return new javax.naming.InitialContext();
    }
}
